 ; Ŀ
 ;   Lx - extract an attribute from a block without exploding it, or       
 ;   copy text from a text entity or out of a block or xref.               
 ;   Copyright 1995, 2010 by Rocket Software Ltd.                          
 ;   If you have to ask, you wouldn't understand.                          
 ; 

 ; Ŀ
 ;   Lerx - error handler.                                                 
 ; 
 (DEFUN Lerx (shk /)
  (setq *error* esav)
  (if (/= shk "Function cancelled") (write-line shk))
  (setvar "snapmode" snapp)
 (princ))
 ; Ŀ
 ;   Lerx end.                                                             
 ; 

 ; Ŀ
 ;   Fando - see if a string contains a substring.                         
 ;   Takes three arguments:  Loc, the substring.                           
 ;                           Txt, the string.                              
 ;                           Cas, if this is non-nil then the search       
 ;                                is non-case-sensitive.                   
 ;   Returns T if the substring was present, nil otherwise.                
 ; 
 (DEFUN FANDO (loc txt cas / ln sta chflg)
  (if cas 
      (progn
           (setq loc (strcase loc t))
           (setq txt (strcase txt t))))
  (setq ln (strlen loc))
  (setq sta 1)
  (while (= ln (strlen (setq st (substr txt sta ln))))
         (if (= st loc) (setq chflg T))
         (setq sta (1+ sta)))
 chflg) 
 ; Ŀ
 ;   Fando end.                                                            
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Txsuck - duplicate a text entity.                          
 ; 
 (DEFUN TXSUCK (entt / bbf nn sublst asonum)
  (setq nn 0)
  (while (setq sublst (nth nn entt))
         (setq asonum (car sublst))
         (cond ((= 8 asonum)
                (if (or (fando "|" (cdr sublst) ())
                        (= (cdr sublst) "0"))
                    (setq bbf (cons (cons 8 "Text2") bbf))
                    (setq bbf (cons sublst bbf))))
               ((= 7 asonum)
                (if (fando "|" (cdr sublst) ())
                    (setq bbf (cons (cons 7 "STANDARD") bbf))
                    (setq bbf (cons sublst bbf))))
               ((not (or (= -1 asonum)
                         (= 5 asonum)))
                (setq bbf (cons sublst bbf))))
         (setq nn (1+ nn)))
 (setq bbf (reverse bbf)))
 ; Ŀ
 ;   Txsuck end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Suck - copy an attribute as a text entity.                 
 ; 
 (DEFUN SUCK (entt / bbf nn sublst asonum)
  (setq bbf (list (cons 0 "TEXT")))
  (setq nn 0)
  (while (setq sublst (nth nn entt))
         (setq asonum (car sublst))
         (cond ((not (or (= -1 asonum)
                         (= 0 asonum)
                         (= 2 asonum)
                         (= 3 asonum)
                         (= 5 asonum)
                         (= 70 asonum)
                         (= 62 asonum)     ; colour - should be bylayer
                         (= 8 asonum)      ; layer - should be text2
                         (= 74 asonum)
                         (= 73 asonum)
                         (= 280 asonum)))  ; attribute position lock flag
                (setq bbf (cons sublst bbf)))
               ((= 74 asonum)
                (setq bbf (cons (cons 73 (cdr sublst)) bbf)))
               ((= 8 asonum)
                (if (= (cdr sublst) "0")
                    (setq bbf (cons (cons 8 "TEXT2") bbf))
                    (setq bbf (cons sublst bbf)))))
         (setq nn (1+ nn)))
 (setq bbf (reverse bbf)))
 ; Ŀ
 ;   Suck end.                                                             
 ; 

 ; Ŀ
 ;   Lx: the innertube-like haemovore.                                     
 ; 
 (DEFUN C:LX (/ enam entt)
  (setq esav *error*)
  (setq *error* lerx)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (if (setq enam (car (nentsel "Attribute to suck: ")))
      (setq entt (entget enam))
      (write-line "\nNothing selected."))
  (if (and entt (or (and (= (cdr (assoc 0 entt)) "ATTRIB")
                         (setq entt (suck entt)))
                    (and (= (cdr (assoc 0 entt)) "TEXT")
                         (setq entt (txsuck entt)))))
      (progn
           (if (entmake entt)
               (progn
                    (write-line "\nSuccessful suck.")
                    (setq pa (spit (entget (entlast))))
                    (command "move" "l" "" pa)
                    (setvar "snapmode" snapp)
                    (while (/= 0 (getvar "cmdactive"))
                           (command pause))
                    (redraw enam))
               (write-line "\nIncomplete suck - program aborted.")))
      (if entt
          (write-line "\nYou must select an attribute in a block insertion.")))
  (setvar "snapmode" snapp)
  (setq *error* esav)
 (princ))